<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
<#if de.getStorageMode()==1>
	<#if  de.getAllPSDEDataSets()??>
		<#assign resultSet=de.getAllPSDEDataSets()>
	</#if>
	<#if  de.getAllPSDEDataQueries()??>
		<#assign dataQueries=de.getAllPSDEDataQueries()>
	</#if>
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">

<mapper	namespace="${pub.getPKGCodeName()}.core.${de.getPSSystemModule().codeName?lower_case}.mapper.${de.codeName}Mapper">

    <!--该方法用于重写mybatis中selectById方法，以实现查询逻辑属性-->
	<#comment>无视图模式-查询view的数据查询</#comment>
	<#if de.isNoViewMode()==true>
		<#list dataQueries as singleQuery>
			<#if singleQuery.getCodeName()?lower_case=='view'>
				<#if singleQuery.getAllPSDEDataQueryCodes()??>
					<#assign queryCodeList = singleQuery.getAllPSDEDataQueryCodes()>
					<#list singleQuery.getAllPSDEDataQueryCodes() as dedqcode>
						<#assign dbtype=dedqcode.getDBType()?lower_case?replace("mysql5","mysql")>
	<select id="selectById"  resultMap="${de.codeName}ResultMap" databaseId="${dbtype}">
        <![CDATA[select t1.* from (${contextParamConvert(srfjavasqlcode(dedqcode.getQueryCode()))}) t1 where ${de.getKeyPSDEField().name?lower_case}=<#noparse>#{id}</#noparse>]]>
    </select>
					</#list>
				</#if>
				<#break>
			</#if>
		</#list>
	<#else>
		<#comment>直接查询视图</#comment>
		<#list dataQueries as singleQuery>
			<#list singleQuery.getAllPSDEDataQueryCodes() as dedqcode>
				<#assign dbtype=dedqcode.getDBType()?lower_case?replace("mysql5","mysql")>
	<select id="selectById"  resultMap="${de.codeName}ResultMap" databaseId="${dbtype}">
        <![CDATA[select * from ${de.getViewName()?lower_case} t1     where  ${de.getKeyPSDEField().name?lower_case}=<#noparse>#{id}</#noparse>]]>
    </select>
			</#list>
			<#break>
		</#list>
	</#if>

    <!--通过mybatis将查询结果注入到entity中,通过配置autoMapping="true"由mybatis自动处理映射关系 -->
    <resultMap id="${de.codeName}ResultMap" type="${pub.getPKGCodeName()}.core.${de.getPSSystemModule().codeName?lower_case}.domain.${de.codeName}" autoMapping="true">
        <id property="${srfcaseformat(de.getKeyPSDEField().codeName,'l_u2lC')}" column="${de.getKeyPSDEField().getName()?lower_case}" /><!--主键字段映射-->
		<#comment>外键值字段映射：由于需要将一个数据库列注入到2个domian属性中(主关系实体对象)，由于已经手动将列映射给主关系对象，所以autoMapping将不会自动注入外键id，需要再次声明映射关系</#comment>
            <#comment>属性名称与代码名称不一致时，强制进行映射</#comment>
            <#list item.getPSDEFields() as defield>
            <#if defield.isKeyDEField()!=true && ((defield.getDataType())!"")!='ONE2MANYDATA'>
                <#if srfcaseformat(defield.codeName,'l_u2lC')?lower_case != defield.name?lower_case || defield.getDataType()=='PICKUP'>
		<result property="${srfcaseformat(defield.codeName,'l_u2lC')}" column="${defield.getName()?lower_case}" />
                </#if>
            </#if>
            </#list>
            
        <#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
		<#if de.getMajorPSDERs?? && de.getMajorPSDERs()??>
			<#list de.getMajorPSDERs() as MajorPSDER>
				<#if MajorPSDER??>
					<#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??  && MajorPSDER.getDERType()=='DER1N' >
						<#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
						<#assign MajorDerField = MajorPSDER.getPSPickupDEField()>
						<#assign listcode=(MajorPSDER.getMinorCodeName()!MajorPSDER.getMinorPSDataEntity().getCodeName())>
						<#if listcode?? && listcode==''><#assign listcode=MajorPSDER.getMinorPSDataEntity().getCodeName()></#if>
                        <#assign nested=MajorPSDER.isNestedRS()>
                        <#if nested == false && MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs()??>
                            <#list MajorPSDER.getMinorPSDataEntity().getAllPSDEServiceAPIs() as api>
                                <#if api.isNested()>
                                    <#assign nested=true>
                                </#if>
                            </#list>
                        </#if>
                        <#if nested>
                            <#if MinorEntity.getStorageMode()==0 && MajorPSDER.getPSOne2ManyDataDEField()?? && MajorPSDER.getPSOne2ManyDataDEField().isPhisicalDEField()==true>
                            <#assign columnname=MajorPSDER.getPSOne2ManyDataDEField().getName()?lower_case>
		<result property="${srfcaseformat(listcode,'l_u2lC')}" column="${columnname}" typeHandler="${pub.getPKGCodeName()}.core.${MinorEntity.getPSSystemModule().codeName?lower_case}.domain.handlers.${MinorEntity.codeName}TypeHandler" />
                            </#if>
		<#--<collection property="${srfcaseformat(listcode,'l_u2lC')}" ofType="${pub.getPKGCodeName()}.core.${MinorEntity.getPSSystemModule().codeName?lower_case}.domain.${MinorEntity.codeName}" column="${de.getKeyPSDEField().getName()?lower_case}" select="${pub.getPKGCodeName()}.core.${MinorEntity.getPSSystemModule().codeName?lower_case}.mapper.${MinorEntity.codeName}Mapper.selectBy${srfcaseformat(MajorDerField.codeName,'l_u2lC')?cap_first}" fetchType="lazy"></collection>-->
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
		
		<#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
		<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
			<#list de.getMinorPSDERs() as MinorPSDER>
				<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
					<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
						<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
						<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? && MajorEntity.getStorageMode()==1>
							<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
								<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
								<#assign MajorField = MinorPSDER.getPSPickupDEField()>
		<!--通过mybatis自动注入关系属性[主实体]，fetchType="lazy"为懒加载配置 -->
		<association property="${srfcaseformat(MinorPSDER.getCodeName(),'l_u2lC')}" javaType="${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().codeName?lower_case}.domain.${MajorEntity.codeName}" column="${MajorField.getName()?lower_case}" select="${pub.getPKGCodeName()}.core.${MajorEntity.getPSSystemModule().codeName?lower_case}.mapper.${MajorEntity.codeName}Mapper.selectById" fetchType="lazy"></association>
							</#if>
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
    </resultMap>

    <#comment>1：N关系中，在子实体中创建父实体的实例对象</#comment>
	<#if de.getMinorPSDERs?? && de.getMinorPSDERs()??>
		<#list de.getMinorPSDERs() as MinorPSDER>
			<#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
				<#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
					<#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
					<#if MajorEntity.name?? && MinorPSDER.getCodeName()?? >
						<#if MinorPSDER.getPSPickupDEField?? && MinorPSDER.getPSPickupDEField()??>
							<#assign MajorkeyField = MajorEntity.getKeyPSDEField()>
							<#assign MajorField = MinorPSDER.getPSPickupDEField()>
	<!--关系实体暴露select方法供主实体通过外键查询关系实体数据[实体关系名称:${MinorPSDER.getName()}] -->
							<#if de.getDefaultPSDEDataSet()??>
								<#assign deDefaultDataSet=de.getDefaultPSDEDataSet()>
								<#if deDefaultDataSet.getPSDEDataQueries()??>
	 <select id="selectBy${srfcaseformat(MajorField.codeName,'l_u2lC')?cap_first}" resultMap="${de.codeName}ResultMap">
         select t1.* from (
         <#if deDefaultDataSet.getPSDEDataQueries()??>
			 <#list deDefaultDataSet.getPSDEDataQueries() as defaultDQ>
				 <#if defaultDQ_index gt 0>
                 union all
				 </#if>
                <include refid="${defaultDQ.getCodeName()}" />
			 </#list>
		 </#if>
         ) t1
         where  ${MajorField.getName()?lower_case}=<#noparse>#{</#noparse>${MajorkeyField.codeName?lower_case}<#noparse>}</#noparse>
     </select>
								</#if>
							</#if>
						</#if>
					</#if>
				</#if>
			</#if>
		</#list>
	</#if>

	<#comment>暂未实现多数据源，暂时先发布单数据库</#comment>
	<#if resultSet??>
		<#list resultSet as  singleSet>
			<#if singleSet.getPSDEDataQueries()??>
    <!--数据集合[${singleSet.getCodeName()}]-->
	 <select id="search${singleSet.getCodeName()}"  parameterType="${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.filter.${de.codeName}SearchContext"  <#if singleSet.isEnableGroup()>resultType="java.util.HashMap"<#else>resultMap="${de.codeName}ResultMap"</#if>>
	 <#if singleSet.isEnableGroup()>
	 	select <#list singleSet.getPSDEDataSetGroupParams() as groupParam><#if groupParam_index gt 0>,</#if><#if groupParam.isEnableGroup()><#if groupParam.getGroupCode()??>${groupParam.getGroupCode()}<#else>${groupParam.getName()}</#if><#else>${groupParam.getGroupCode()}</#if> as "${groupParam.getName()?lower_case}"</#list> from (
	 </#if>
         select t1.* from (
            <#list singleSet.getPSDEDataQueries() as dataQuery>
				<#if dataQuery_index gt 0>
                 union all
				</#if>
                <include refid="${dataQuery.getCodeName()}" />
			</#list>
         )t1
         <where><if test="ew!=null and ew.sqlSegment!=null and !ew.emptyOfWhere"><#noparse>${ew.sqlSegment}</#noparse></if></where>
         <if test="ew!=null and ew.sqlSegment!=null and ew.emptyOfWhere"><#noparse>${ew.sqlSegment}</#noparse></if>
	<#if singleSet.isEnableGroup()> 
		 ) groupinfo
		 group by <#assign groupIndex = 0 ><#list singleSet.getPSDEDataSetGroupParams() as groupParam><#if groupParam.isEnableGroup()><#if groupIndex gt 0>,</#if><#if groupParam.getGroupCode()??>${groupParam.getGroupCode()}<#else>${groupParam.getName()}</#if><#assign groupIndex = groupIndex + 1 ></#if></#list>
	</#if>
     </select>

			</#if>
		</#list>
	</#if>
    <#comment>数据查询</#comment>
    <#if  de.getAllPSDEDataQueries()??>
		<#list de.getAllPSDEDataQueries() as singleQuery>
			<#if singleQuery.getAllPSDEDataQueryCodes()??>
				<#list singleQuery.getAllPSDEDataQueryCodes() as dedqcode>
					<#assign dbtype=dedqcode.getDBType()?lower_case?replace("mysql5","mysql")>
    <!--数据查询[${singleQuery.getCodeName()}]-->
    <sql id="${singleQuery.getCodeName()}" databaseId="${dbtype}">
       <![CDATA[	${contextParamConvert(srfjavasqlcode(dedqcode.getQueryCode()))}
            <#if dedqcode.getPSDEDataQueryCodeConds()??>
            <#list dedqcode.getPSDEDataQueryCodeConds() as dedqfieldcond>
				<#if (dedqfieldcond_index==0)> WHERE </#if>	<#if (dedqfieldcond_index>0)> AND </#if>${contextParamConvert(srfjavasqlcode(dedqfieldcond.getCustomCond()))}
			</#list>
			</#if>]]>
    </sql>

				</#list>
			</#if>
		</#list>
	</#if>
</mapper>
</#if>

<#comment>上下文参数转换  原字符串：${srfdatacontext('field','{"defname":"PORGNAME","dename":"IBZORG"}')})</#comment>
<#comment>第一次替换：#{srf.datacontext.field','{"defname":"PORGNAME","dename":"IBZORG"}')})</#comment>
<#comment>第二次替换：#{srf.datacontext.field}</#comment>
<#function contextParamConvert contextParam>
	<#assign resultParam="">
	<#assign resultParam=contextParam?replace('$\{srfdatacontext(\'','#\{srf.datacontext.')?replace("','\\{[\\S]*}'\\)}","\\}","r")><#comment>数据上下文</#comment>
	<#assign resultParam=resultParam?replace('$\{srfsessioncontext(\'','#\{srf.sessioncontext.')?replace("','\\{[\\S]*}'\\)}","\\}","r")><#comment>用户上下文</#comment>
	<#assign resultParam=resultParam?replace('$\{srfwebcontext(\'','#\{srf.webcontext.')?replace("','\\{[\\S]*}'\\)}","\\}","r")><#comment>网页请求上下文</#comment>
	<#return resultParam>
</#function>
